package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsExtensions;
import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

@Component
public class MyGoalExtensionsDTOConverter implements Converter<MyGoalsExtensionDTO, MyGoalsExtensions> {

	@Autowired
	private MyGoalTaskDTOConverter myGoalTaskDTOConverter;

	@Override
	public MyGoalsExtensions convert(MyGoalsExtensionDTO dto) {
		MyGoalsExtensions e = new MyGoalsExtensions();
		
		e.setDescription(dto.getDescription());
		e.setGoalExtensionId(dto.getGoalExtensionId());
		e.setGoalExtensionSequenceNumber(dto.getGoalExtensionSequenceNumber());
		e.setGoalExtensionType(dto.getGoalExtensionType());
		e.setOplock(dto.getOplock());

		if (dto.getMyGoalsTasks() != null) {
			for (MyGoalTaskDTO taskDTO : dto.getMyGoalsTasks()) {
				MyGoalsTasks task = myGoalTaskDTOConverter.convert(taskDTO);
				e.addMyGoalsTask(task);
			}
		}

		return e;
	}

}
